/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation.internal;

import com.vladsch.flexmark.ext.abbreviation.Abbreviation;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationFormatOptions;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationRepository;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.NodeRepositoryFormatter;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbbreviationNodeFormatter
extends NodeRepositoryFormatter<AbbreviationRepository, AbbreviationBlock, Abbreviation> {
    public static final DataKey<Map<String, String>> ABBREVIATION_TRANSLATION_MAP = new DataKey("ABBREVIATION_TRANSLATION_MAP", new HashMap());
    public static final DataKey<Map<String, String>> ABBREVIATION_UNIQUIFICATION_MAP = new DataKey("ABBREVIATION_UNIQUIFICATION_MAP", new HashMap());
    private final AbbreviationFormatOptions options;
    private final boolean transformUnderscores;
    private final boolean makeMergedAbbreviationsUnique;

    public AbbreviationNodeFormatter(DataHolder options) {
        super(options, ABBREVIATION_TRANSLATION_MAP, ABBREVIATION_UNIQUIFICATION_MAP);
        this.options = new AbbreviationFormatOptions(options);
        String transformedId = String.format(Formatter.TRANSLATION_ID_FORMAT.get(options), 1);
        this.transformUnderscores = transformedId.startsWith("_") && transformedId.endsWith("_");
        this.makeMergedAbbreviationsUnique = AbbreviationExtension.MAKE_MERGED_ABBREVIATIONS_UNIQUE.get(options);
    }

    @Override
    protected boolean makeReferencesUnique() {
        return this.makeMergedAbbreviationsUnique;
    }

    @Override
    public AbbreviationRepository getRepository(DataHolder options) {
        return AbbreviationExtension.ABBREVIATIONS.get(options);
    }

    @Override
    public ElementPlacement getReferencePlacement() {
        return this.options.abbreviationsPlacement;
    }

    @Override
    public ElementPlacementSort getReferenceSort() {
        return this.options.abbreviationsSort;
    }

    @Override
    public String modifyTransformedReference(String transformedText, NodeFormatterContext context) {
        if (this.transformUnderscores && context.isTransformingText()) {
            if (transformedText.startsWith("-") && transformedText.endsWith("-")) {
                transformedText = "_" + transformedText.substring(1, transformedText.length() - 1) + "_";
            } else if (transformedText.startsWith("_") && transformedText.endsWith("_")) {
                transformedText = "-" + transformedText.substring(1, transformedText.length() - 1) + "-";
            }
        }
        return transformedText;
    }

    @Override
    public void renderReferenceBlock(AbbreviationBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append(node.getOpeningMarker());
        markdown.append(this.transformReferenceId(node.getText().toString(), context));
        ((MarkdownWriter)markdown.append(node.getClosingMarker())).append(' ');
        markdown.appendTranslating(node.getAbbreviation()).line();
    }

    @Override
    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler<Abbreviation>(Abbreviation.class, this::render), new NodeFormattingHandler<AbbreviationBlock>(AbbreviationBlock.class, this::render)));
    }

    @Override
    @Nullable
    public Set<Class<?>> getNodeClasses() {
        if (this.options.abbreviationsPlacement.isNoChange() || !this.options.abbreviationsSort.isUnused()) {
            return null;
        }
        return new HashSet(Arrays.asList(Abbreviation.class));
    }

    private void render(AbbreviationBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference(node, context, markdown);
    }

    private void render(Abbreviation node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText()) {
            String referenceId = this.transformReferenceId(node.getChars().toString(), context);
            markdown.append(referenceId);
        } else {
            markdown.append(node.getChars());
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Override
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new AbbreviationNodeFormatter(options);
        }
    }
}

