/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.ui;

import com.sun.java.swing.action.ActionManager;
import com.sun.java.swing.action.StateChangeAction;
import com.sun.java.swing.ui.CommonUI;
import com.sun.java.swing.ui.StatusBar;
import com.sun.java.swing.ui.ToggleActionPropertyChangeListener;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public abstract class CommonToolBar
extends JToolBar {
    protected ActionManager manager;
    private Dimension buttonSize;
    private Insets buttonInsets;
    private StatusBar statusBar;

    protected CommonToolBar(ActionManager manager) {
        this(manager, StatusBar.getInstance());
    }

    protected CommonToolBar(ActionManager manager, StatusBar status) {
        this.manager = manager;
        this.statusBar = status;
        this.buttonSize = new Dimension(CommonUI.buttconPrefSize);
        this.buttonInsets = new Insets(0, 0, 0, 0);
        this.addComponents();
    }

    protected abstract void addComponents();

    protected void addButton(Action action) {
        JButton button = this.add(action);
        this.configureButton(button, action);
    }

    protected void addToggleButton(StateChangeAction a) {
        this.addToggleButton(a, null);
    }

    protected void addToggleButton(StateChangeAction a, ButtonGroup group) {
        JToggleButton button = new JToggleButton(a);
        button.addItemListener(a);
        button.setSelected(a.isSelected());
        if (group != null) {
            group.add(button);
        }
        this.add(button);
        this.configureToggleButton(button, a);
    }

    protected void configureToggleButton(JToggleButton button, Action action) {
        this.configureButton(button, action);
        action.addPropertyChangeListener(new ToggleActionPropertyChangeListener(button));
    }

    protected void configureButton(AbstractButton button, Action action) {
        button.setToolTipText((String)action.getValue("Name"));
        button.setText("");
        button.addMouseListener(this.statusBar);
    }
}

