/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.module;

import com.beust.jcommander.JCommander;
import com.ncloud.api.cli.common.model.CommandEnum;
import com.ncloud.api.cli.common.model.CommandOption;
import com.ncloud.api.cli.common.options.GlobalOptions;
import com.ncloud.api.cli.common.util.CliCallUtil;
import com.ncloud.api.cli.common.util.CommandUtil;
import com.ncloud.api.cli.common.util.GlobalOptionUtil;
import com.ncloud.api.cli.exception.NcloudCliException;
import com.ncloud.api.cli.loadbalancer.options.AddLoadBalancerSslCertificateOptions;
import com.ncloud.api.cli.loadbalancer.options.ChangeLoadBalancedServerInstancesOptions;
import com.ncloud.api.cli.loadbalancer.options.ChangeLoadBalancerInstanceConfigurationOptions;
import com.ncloud.api.cli.loadbalancer.options.CreateLoadBalancerInstanceOptions;
import com.ncloud.api.cli.loadbalancer.options.DeleteLoadBalancerInstancesOptions;
import com.ncloud.api.cli.loadbalancer.options.DeleteLoadBalancerSslCertificateOptions;
import com.ncloud.api.cli.loadbalancer.options.GetLoadBalancedServerInstanceListOptions;
import com.ncloud.api.cli.loadbalancer.options.GetLoadBalancerInstanceListOptions;
import com.ncloud.api.cli.loadbalancer.options.GetLoadBalancerSslCertificateListOptions;
import com.ncloud.api.cli.loadbalancer.options.GetLoadBalancerTargetServerInstanceListOptions;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loadbalancer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void execute(JCommander loadbalancerCommander, CommandEnum.LoadbalancerCommand loadbalancerCommand) throws NcloudCliException, UnsupportedEncodingException {
        JCommander subCommander = loadbalancerCommander.getCommands().get(loadbalancerCommand.getCode());
        CommandOption commandOption = null;
        String requestUri = null;
        switch (loadbalancerCommand) {
            case createLoadBalancerInstance: {
                requestUri = "/loadbalancer/v2/createLoadBalancerInstance";
                commandOption = (CreateLoadBalancerInstanceOptions)subCommander.getObjects().get(0);
                break;
            }
            case getLoadBalancerInstanceList: {
                requestUri = "/loadbalancer/v2/getLoadBalancerInstanceList";
                commandOption = (GetLoadBalancerInstanceListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getLoadBalancerTargetServerInstanceList: {
                requestUri = "/loadbalancer/v2/getLoadBalancerTargetServerInstanceList";
                commandOption = (GetLoadBalancerTargetServerInstanceListOptions)subCommander.getObjects().get(0);
                break;
            }
            case changeLoadBalancerInstanceConfiguration: {
                requestUri = "/loadbalancer/v2/changeLoadBalancerInstanceConfiguration";
                commandOption = (ChangeLoadBalancerInstanceConfigurationOptions)subCommander.getObjects().get(0);
                break;
            }
            case getLoadBalancedServerInstanceList: {
                requestUri = "/loadbalancer/v2/getLoadBalancedServerInstanceList";
                commandOption = (GetLoadBalancedServerInstanceListOptions)subCommander.getObjects().get(0);
                break;
            }
            case changeLoadBalancedServerInstances: {
                requestUri = "/loadbalancer/v2/changeLoadBalancedServerInstances";
                commandOption = (ChangeLoadBalancedServerInstancesOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteLoadBalancerInstances: {
                requestUri = "/loadbalancer/v2/deleteLoadBalancerInstances";
                commandOption = (DeleteLoadBalancerInstancesOptions)subCommander.getObjects().get(0);
                break;
            }
            case getLoadBalancerSslCertificateList: {
                requestUri = "/loadbalancer/v2/getLoadBalancerSslCertificateList";
                commandOption = (GetLoadBalancerSslCertificateListOptions)subCommander.getObjects().get(0);
                break;
            }
            case addLoadBalancerSslCertificate: {
                requestUri = "/loadbalancer/v2/addLoadBalancerSslCertificate";
                commandOption = (AddLoadBalancerSslCertificateOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteLoadBalancerSslCertificate: {
                requestUri = "/loadbalancer/v2/deleteLoadBalancerSslCertificate";
                commandOption = (DeleteLoadBalancerSslCertificateOptions)subCommander.getObjects().get(0);
                break;
            }
        }
        if (null != requestUri) {
            GlobalOptions globalOptions = commandOption.getCommandOptions().getGlobalOptions();
            String profile = globalOptions.getProfile();
            boolean isDebug = GlobalOptionUtil.getIsDebug();
            if (profile == null) {
                profile = "DEFAULT";
            }
            CliCallUtil.call(globalOptions, CommandUtil.getNcloudNewApiRequest(profile, isDebug), requestUri, commandOption);
        }
    }
}

