/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.remoting.httpinvoker.AbstractHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.support.RemoteInvocationResult;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HttpComponentsHttpInvokerRequestExecutor
extends AbstractHttpInvokerRequestExecutor {
    private static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 100;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 5;
    private static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    private HttpClient httpClient;

    public HttpComponentsHttpInvokerRequestExecutor() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(schemeRegistry);
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(5);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        this.setReadTimeout(60000);
    }

    public HttpComponentsHttpInvokerRequestExecutor(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setConnectTimeout(int timeout) {
        Assert.isTrue(timeout >= 0, "Timeout must be a non-negative value");
        this.getHttpClient().getParams().setIntParameter("http.connection.timeout", timeout);
    }

    public void setReadTimeout(int timeout) {
        Assert.isTrue(timeout >= 0, "Timeout must be a non-negative value");
        this.getHttpClient().getParams().setIntParameter("http.socket.timeout", timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration config, ByteArrayOutputStream baos) throws IOException, ClassNotFoundException {
        HttpPost postMethod = this.createHttpPost(config);
        this.setRequestBody(config, postMethod, baos);
        try {
            HttpResponse response = this.executeHttpPost(config, this.getHttpClient(), postMethod);
            this.validateResponse(config, response);
            InputStream responseBody = this.getResponseBody(config, response);
            RemoteInvocationResult remoteInvocationResult = this.readRemoteInvocationResult(responseBody, config.getCodebaseUrl());
            return remoteInvocationResult;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    protected HttpPost createHttpPost(HttpInvokerClientConfiguration config) throws IOException {
        HttpPost httpPost = new HttpPost(config.getServiceUrl());
        LocaleContext locale = LocaleContextHolder.getLocaleContext();
        if (locale != null) {
            httpPost.addHeader("Accept-Language", StringUtils.toLanguageTag(locale.getLocale()));
        }
        if (this.isAcceptGzipEncoding()) {
            httpPost.addHeader("Accept-Encoding", "gzip");
        }
        return httpPost;
    }

    protected void setRequestBody(HttpInvokerClientConfiguration config, HttpPost httpPost, ByteArrayOutputStream baos) throws IOException {
        ByteArrayEntity entity = new ByteArrayEntity(baos.toByteArray());
        entity.setContentType(this.getContentType());
        httpPost.setEntity((HttpEntity)entity);
    }

    protected HttpResponse executeHttpPost(HttpInvokerClientConfiguration config, HttpClient httpClient, HttpPost httpPost) throws IOException {
        return httpClient.execute((HttpUriRequest)httpPost);
    }

    protected void validateResponse(HttpInvokerClientConfiguration config, HttpResponse response) throws IOException {
        StatusLine status = response.getStatusLine();
        if (status.getStatusCode() >= 300) {
            throw new NoHttpResponseException("Did not receive successful HTTP response: status code = " + status.getStatusCode() + ", status message = [" + status.getReasonPhrase() + "]");
        }
    }

    protected InputStream getResponseBody(HttpInvokerClientConfiguration config, HttpResponse httpResponse) throws IOException {
        if (this.isGzipResponse(httpResponse)) {
            return new GZIPInputStream(httpResponse.getEntity().getContent());
        }
        return httpResponse.getEntity().getContent();
    }

    protected boolean isGzipResponse(HttpResponse httpResponse) {
        Header encodingHeader = httpResponse.getFirstHeader("Content-Encoding");
        return encodingHeader != null && encodingHeader.getValue() != null && encodingHeader.getValue().toLowerCase().contains("gzip");
    }
}

