/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.fdf.FDFCatalog;
import org.apache.pdfbox.pdmodel.fdf.FDFDictionary;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFField;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTree;
import org.apache.pdfbox.pdmodel.interactive.form.PDTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDXFAResource;
import org.apache.pdfbox.util.Matrix;

public final class PDAcroForm
implements COSObjectable {
    private static final Log LOG = LogFactory.getLog(PDAcroForm.class);
    private static final int FLAG_SIGNATURES_EXIST = 1;
    private static final int FLAG_APPEND_ONLY = 2;
    private final PDDocument document;
    private final COSDictionary dictionary;
    private Map<String, PDField> fieldCache;

    public PDAcroForm(PDDocument doc) {
        this.document = doc;
        this.dictionary = new COSDictionary();
        this.dictionary.setItem(COSName.FIELDS, (COSBase)new COSArray());
    }

    public PDAcroForm(PDDocument doc, COSDictionary form) {
        this.document = doc;
        this.dictionary = form;
        this.verifyOrCreateDefaults();
    }

    private void verifyOrCreateDefaults() {
        COSDictionary fontDict;
        PDResources defaultResources;
        String adobeDefaultAppearanceString = "/Helv 0 Tf 0 g ";
        if (this.getDefaultAppearance().length() == 0) {
            this.setDefaultAppearance("/Helv 0 Tf 0 g ");
            this.dictionary.setNeedToBeUpdated(true);
        }
        if ((defaultResources = this.getDefaultResources()) == null) {
            defaultResources = new PDResources();
            this.setDefaultResources(defaultResources);
            this.dictionary.setNeedToBeUpdated(true);
        }
        if ((fontDict = defaultResources.getCOSObject().getCOSDictionary(COSName.FONT)) == null) {
            fontDict = new COSDictionary();
            defaultResources.getCOSObject().setItem(COSName.FONT, (COSBase)fontDict);
        }
        if (!fontDict.containsKey(COSName.HELV)) {
            defaultResources.put(COSName.HELV, PDType1Font.HELVETICA);
            defaultResources.getCOSObject().setNeedToBeUpdated(true);
            fontDict.setNeedToBeUpdated(true);
        }
        if (!fontDict.containsKey(COSName.ZA_DB)) {
            defaultResources.put(COSName.ZA_DB, PDType1Font.ZAPF_DINGBATS);
            defaultResources.getCOSObject().setNeedToBeUpdated(true);
            fontDict.setNeedToBeUpdated(true);
        }
    }

    PDDocument getDocument() {
        return this.document;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public void importFDF(FDFDocument fdf) throws IOException {
        List<FDFField> fields = fdf.getCatalog().getFDF().getFields();
        if (fields != null) {
            for (FDFField field : fields) {
                FDFField fdfField = field;
                PDField docField = this.getField(fdfField.getPartialFieldName());
                if (docField == null) continue;
                docField.importFDF(fdfField);
            }
        }
    }

    public FDFDocument exportFDF() throws IOException {
        FDFDocument fdf = new FDFDocument();
        FDFCatalog catalog = fdf.getCatalog();
        FDFDictionary fdfDict = new FDFDictionary();
        catalog.setFDF(fdfDict);
        ArrayList<FDFField> fdfFields = new ArrayList<FDFField>();
        List<PDField> fields = this.getFields();
        for (PDField field : fields) {
            fdfFields.add(field.exportFDF());
        }
        fdfDict.setID(this.document.getDocument().getDocumentID());
        if (!fdfFields.isEmpty()) {
            fdfDict.setFields(fdfFields);
        }
        return fdf;
    }

    public void flatten() throws IOException {
        if (this.xfaIsDynamic()) {
            LOG.warn("Flatten for a dynamix XFA form is not supported");
            return;
        }
        ArrayList<PDField> fields = new ArrayList<PDField>();
        for (PDField field : this.getFieldTree()) {
            fields.add(field);
        }
        this.flatten(fields, false);
    }

    public void flatten(List<PDField> fields, boolean refreshAppearances) throws IOException {
        if (fields.isEmpty()) {
            return;
        }
        if (!refreshAppearances && this.getNeedAppearances()) {
            LOG.warn("acroForm.getNeedAppearances() returns true, visual field appearances may not have been set");
            LOG.warn("call acroForm.refreshAppearances() or use the flatten() method with refreshAppearances parameter");
        }
        if (this.xfaIsDynamic()) {
            LOG.warn("Flatten for a dynamix XFA form is not supported");
            return;
        }
        if (refreshAppearances) {
            this.refreshAppearances(fields);
        }
        Map<COSDictionary, Map<COSDictionary, PDAnnotationWidget>> pagesWidgetsMap = this.buildPagesWidgetsMap(fields);
        for (PDPage page : this.document.getPages()) {
            Map<COSDictionary, PDAnnotationWidget> widgetsForPageMap = pagesWidgetsMap.get(page.getCOSObject());
            boolean isContentStreamWrapped = false;
            ArrayList<PDAnnotation> annotations = new ArrayList<PDAnnotation>();
            for (PDAnnotation annotation : page.getAnnotations()) {
                PDPageContentStream contentStream;
                if (widgetsForPageMap != null && widgetsForPageMap.get(annotation.getCOSObject()) == null) {
                    annotations.add(annotation);
                    continue;
                }
                if (annotation.isInvisible() || annotation.isHidden() || annotation.getNormalAppearanceStream() == null) continue;
                if (!isContentStreamWrapped) {
                    contentStream = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.APPEND, true, true);
                    isContentStreamWrapped = true;
                } else {
                    contentStream = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.APPEND, true);
                }
                PDAppearanceStream appearanceStream = annotation.getNormalAppearanceStream();
                PDFormXObject fieldObject = new PDFormXObject(appearanceStream.getCOSObject());
                contentStream.saveGraphicsState();
                boolean needsTranslation = this.resolveNeedsTranslation(appearanceStream);
                boolean needsScaling = this.resolveNeedsScaling(appearanceStream);
                Matrix transformationMatrix = new Matrix();
                boolean transformed = false;
                if (needsTranslation) {
                    transformationMatrix.translate(annotation.getRectangle().getLowerLeftX(), annotation.getRectangle().getLowerLeftY());
                    transformed = true;
                }
                if (needsScaling) {
                    PDRectangle bbox = appearanceStream.getBBox();
                    PDRectangle fieldRect = annotation.getRectangle();
                    if (bbox.getWidth() - fieldRect.getWidth() != 0.0f && bbox.getHeight() - fieldRect.getHeight() != 0.0f) {
                        float xScale = fieldRect.getWidth() / bbox.getWidth();
                        float yScale = fieldRect.getHeight() / bbox.getHeight();
                        Matrix scalingMatrix = Matrix.getScaleInstance(xScale, yScale);
                        transformationMatrix.concatenate(scalingMatrix);
                        transformed = true;
                    }
                }
                if (transformed) {
                    contentStream.transform(transformationMatrix);
                }
                contentStream.drawForm(fieldObject);
                contentStream.restoreGraphicsState();
                contentStream.close();
            }
            page.setAnnotations(annotations);
        }
        this.removeFields(fields);
        this.dictionary.removeItem(COSName.XFA);
    }

    public void refreshAppearances() throws IOException {
        for (PDField field : this.getFieldTree()) {
            if (!(field instanceof PDTerminalField)) continue;
            ((PDTerminalField)field).constructAppearances();
        }
    }

    public void refreshAppearances(List<PDField> fields) throws IOException {
        for (PDField field : fields) {
            if (!(field instanceof PDTerminalField)) continue;
            ((PDTerminalField)field).constructAppearances();
        }
    }

    public List<PDField> getFields() {
        COSArray cosFields = (COSArray)this.dictionary.getDictionaryObject(COSName.FIELDS);
        if (cosFields == null) {
            return Collections.emptyList();
        }
        ArrayList<PDField> pdFields = new ArrayList<PDField>();
        for (int i = 0; i < cosFields.size(); ++i) {
            PDField field;
            COSDictionary element = (COSDictionary)cosFields.getObject(i);
            if (element == null || (field = PDField.fromDictionary(this, element, null)) == null) continue;
            pdFields.add(field);
        }
        return new COSArrayList<PDField>(pdFields, cosFields);
    }

    public void setFields(List<PDField> fields) {
        this.dictionary.setItem(COSName.FIELDS, (COSBase)COSArrayList.converterToCOSArray(fields));
    }

    public Iterator<PDField> getFieldIterator() {
        return new PDFieldTree(this).iterator();
    }

    public PDFieldTree getFieldTree() {
        return new PDFieldTree(this);
    }

    public void setCacheFields(boolean cache) {
        if (cache) {
            this.fieldCache = new HashMap<String, PDField>();
            for (PDField field : this.getFieldTree()) {
                this.fieldCache.put(field.getFullyQualifiedName(), field);
            }
        } else {
            this.fieldCache = null;
        }
    }

    public boolean isCachingFields() {
        return this.fieldCache != null;
    }

    public PDField getField(String fullyQualifiedName) {
        if (this.fieldCache != null) {
            return this.fieldCache.get(fullyQualifiedName);
        }
        for (PDField field : this.getFieldTree()) {
            if (!field.getFullyQualifiedName().equals(fullyQualifiedName)) continue;
            return field;
        }
        return null;
    }

    public String getDefaultAppearance() {
        return this.dictionary.getString(COSName.DA, "");
    }

    public void setDefaultAppearance(String daValue) {
        this.dictionary.setString(COSName.DA, daValue);
    }

    public boolean getNeedAppearances() {
        return this.dictionary.getBoolean(COSName.NEED_APPEARANCES, false);
    }

    public void setNeedAppearances(Boolean value) {
        this.dictionary.setBoolean(COSName.NEED_APPEARANCES, (boolean)value);
    }

    public PDResources getDefaultResources() {
        PDResources retval = null;
        COSBase base = this.dictionary.getDictionaryObject(COSName.DR);
        if (base instanceof COSDictionary) {
            retval = new PDResources((COSDictionary)base, this.document.getResourceCache());
        }
        return retval;
    }

    public void setDefaultResources(PDResources dr) {
        this.dictionary.setItem(COSName.DR, (COSObjectable)dr);
    }

    public boolean hasXFA() {
        return this.dictionary.containsKey(COSName.XFA);
    }

    public boolean xfaIsDynamic() {
        return this.hasXFA() && this.getFields().isEmpty();
    }

    public PDXFAResource getXFA() {
        PDXFAResource xfa = null;
        COSBase base = this.dictionary.getDictionaryObject(COSName.XFA);
        if (base != null) {
            xfa = new PDXFAResource(base);
        }
        return xfa;
    }

    public void setXFA(PDXFAResource xfa) {
        this.dictionary.setItem(COSName.XFA, (COSObjectable)xfa);
    }

    public int getQ() {
        int retval = 0;
        COSNumber number = (COSNumber)this.dictionary.getDictionaryObject(COSName.Q);
        if (number != null) {
            retval = number.intValue();
        }
        return retval;
    }

    public void setQ(int q) {
        this.dictionary.setInt(COSName.Q, q);
    }

    public boolean isSignaturesExist() {
        return this.dictionary.getFlag(COSName.SIG_FLAGS, 1);
    }

    public void setSignaturesExist(boolean signaturesExist) {
        this.dictionary.setFlag(COSName.SIG_FLAGS, 1, signaturesExist);
    }

    public boolean isAppendOnly() {
        return this.dictionary.getFlag(COSName.SIG_FLAGS, 2);
    }

    public void setAppendOnly(boolean appendOnly) {
        this.dictionary.setFlag(COSName.SIG_FLAGS, 2, appendOnly);
    }

    private boolean resolveNeedsTranslation(PDAppearanceStream appearanceStream) {
        boolean needsTranslation = true;
        PDResources resources = appearanceStream.getResources();
        if (resources != null && resources.getXObjectNames().iterator().hasNext()) {
            Iterator<COSName> xObjectNames = resources.getXObjectNames().iterator();
            while (xObjectNames.hasNext()) {
                try {
                    PDXObject xObject = resources.getXObject(xObjectNames.next());
                    if (!(xObject instanceof PDFormXObject)) continue;
                    PDRectangle bbox = ((PDFormXObject)xObject).getBBox();
                    float llX = bbox.getLowerLeftX();
                    float llY = bbox.getLowerLeftY();
                    if (Float.compare(llX, 0.0f) == 0 || Float.compare(llY, 0.0f) == 0) continue;
                    needsTranslation = false;
                }
                catch (IOException iOException) {}
            }
            return needsTranslation;
        }
        return true;
    }

    private boolean resolveNeedsScaling(PDAppearanceStream appearanceStream) {
        PDResources resources = appearanceStream.getResources();
        return resources != null && resources.getXObjectNames().iterator().hasNext();
    }

    private Map<COSDictionary, Map<COSDictionary, PDAnnotationWidget>> buildPagesWidgetsMap(List<PDField> fields) {
        HashMap<COSDictionary, Map<COSDictionary, PDAnnotationWidget>> pagesAnnotationsMap = new HashMap<COSDictionary, Map<COSDictionary, PDAnnotationWidget>>();
        boolean hasMissingPageRef = false;
        for (PDField field : fields) {
            List<PDAnnotationWidget> widgets = field.getWidgets();
            for (PDAnnotationWidget widget : widgets) {
                PDPage pageForWidget = widget.getPage();
                if (pageForWidget != null) {
                    Map<COSDictionary, PDAnnotationWidget> widgetsForPage;
                    if (pagesAnnotationsMap.get(pageForWidget.getCOSObject()) == null) {
                        widgetsForPage = new HashMap<COSDictionary, PDAnnotationWidget>();
                        widgetsForPage.put(widget.getCOSObject(), widget);
                        pagesAnnotationsMap.put(pageForWidget.getCOSObject(), widgetsForPage);
                        continue;
                    }
                    widgetsForPage = (Map)pagesAnnotationsMap.get(pageForWidget.getCOSObject());
                    widgetsForPage.put(widget.getCOSObject(), widget);
                    continue;
                }
                hasMissingPageRef = true;
            }
        }
        if (hasMissingPageRef) {
            LOG.warn("There has been a widget with a missing page reference. Please report to the PDFBox project");
        }
        return pagesAnnotationsMap;
    }

    private void removeFields(List<PDField> fields) {
        for (PDField field : fields) {
            COSDictionary element;
            int i;
            if (field.getParent() == null) {
                COSArray cosFields = (COSArray)this.dictionary.getDictionaryObject(COSName.FIELDS);
                for (i = 0; i < cosFields.size(); ++i) {
                    element = (COSDictionary)cosFields.getObject(i);
                    if (!field.getCOSObject().equals(element)) continue;
                    cosFields.remove(i);
                }
                continue;
            }
            COSArray kids = (COSArray)field.getParent().getCOSObject().getDictionaryObject(COSName.KIDS);
            for (i = 0; i < kids.size(); ++i) {
                element = (COSDictionary)kids.getObject(i);
                if (!field.getCOSObject().equals(element)) continue;
                kids.remove(i);
            }
        }
    }
}

