/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.util.Collection;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
public abstract class AbstractAsyncConfiguration
implements ImportAware {
    protected AnnotationAttributes enableAsync;
    protected Executor executor;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableAsync = AnnotationAttributes.fromMap(importMetadata.getAnnotationAttributes(EnableAsync.class.getName(), false));
        Assert.notNull(this.enableAsync, "@EnableAsync is not present on importing class " + importMetadata.getClassName());
    }

    public abstract Object asyncAdvisor();

    @Autowired(required=false)
    void setConfigurers(Collection<AsyncConfigurer> configurers) {
        if (configurers == null || configurers.isEmpty()) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException("only one AsyncConfigurer may exist");
        }
        AsyncConfigurer configurer = configurers.iterator().next();
        this.executor = configurer.getAsyncExecutor();
    }
}

