/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.security.AccessController;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.security.action.GetPropertyAction;
import sun.util.cldr.CLDRLocaleProviderAdapter;
import sun.util.locale.provider.FallbackLocaleProviderAdapter;
import sun.util.locale.provider.HostLocaleProviderAdapter;
import sun.util.locale.provider.JRELocaleConstants;
import sun.util.locale.provider.JRELocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;
import sun.util.locale.provider.LocaleServiceProviderPool;
import sun.util.locale.provider.SPILocaleProviderAdapter;
import sun.util.spi.CalendarProvider;

public abstract class LocaleProviderAdapter {
    private static final List<Type> adapterPreference;
    private static LocaleProviderAdapter jreLocaleProviderAdapter;
    private static LocaleProviderAdapter spiLocaleProviderAdapter;
    private static LocaleProviderAdapter cldrLocaleProviderAdapter;
    private static LocaleProviderAdapter hostLocaleProviderAdapter;
    private static LocaleProviderAdapter fallbackLocaleProviderAdapter;
    static Type defaultLocaleProviderAdapter;
    private static ConcurrentMap<Class<? extends LocaleServiceProvider>, ConcurrentMap<Locale, LocaleProviderAdapter>> adapterCache;

    public static LocaleProviderAdapter forType(Type type) {
        switch (type) {
            case JRE: {
                return jreLocaleProviderAdapter;
            }
            case CLDR: {
                return cldrLocaleProviderAdapter;
            }
            case SPI: {
                return spiLocaleProviderAdapter;
            }
            case HOST: {
                return hostLocaleProviderAdapter;
            }
            case FALLBACK: {
                return fallbackLocaleProviderAdapter;
            }
        }
        throw new InternalError("unknown locale data adapter type");
    }

    public static LocaleProviderAdapter forJRE() {
        return jreLocaleProviderAdapter;
    }

    public static LocaleProviderAdapter getResourceBundleBased() {
        for (Type type : LocaleProviderAdapter.getAdapterPreference()) {
            if (type != Type.JRE && type != Type.CLDR && type != Type.FALLBACK) continue;
            return LocaleProviderAdapter.forType(type);
        }
        throw new InternalError();
    }

    public static List<Type> getAdapterPreference() {
        return adapterPreference;
    }

    public static LocaleProviderAdapter getAdapter(Class<? extends LocaleServiceProvider> clazz, Locale locale) {
        LocaleProviderAdapter localeProviderAdapter;
        ConcurrentHashMap<Locale, LocaleProviderAdapter> concurrentHashMap = (ConcurrentHashMap<Locale, LocaleProviderAdapter>)adapterCache.get(clazz);
        if (concurrentHashMap != null) {
            localeProviderAdapter = (LocaleProviderAdapter)concurrentHashMap.get(locale);
            if (localeProviderAdapter != null) {
                return localeProviderAdapter;
            }
        } else {
            concurrentHashMap = new ConcurrentHashMap<Locale, LocaleProviderAdapter>();
            adapterCache.putIfAbsent(clazz, concurrentHashMap);
        }
        if ((localeProviderAdapter = LocaleProviderAdapter.findAdapter(clazz, locale)) != null) {
            concurrentHashMap.putIfAbsent(locale, localeProviderAdapter);
            return localeProviderAdapter;
        }
        List<Locale> list = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT).getCandidateLocales("", locale);
        for (Locale locale2 : list) {
            if (locale2.equals(locale) || (localeProviderAdapter = LocaleProviderAdapter.findAdapter(clazz, locale2)) == null) continue;
            concurrentHashMap.putIfAbsent(locale, localeProviderAdapter);
            return localeProviderAdapter;
        }
        concurrentHashMap.putIfAbsent(locale, fallbackLocaleProviderAdapter);
        return fallbackLocaleProviderAdapter;
    }

    private static LocaleProviderAdapter findAdapter(Class<? extends LocaleServiceProvider> clazz, Locale locale) {
        for (Type type : LocaleProviderAdapter.getAdapterPreference()) {
            LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.forType(type);
            LocaleServiceProvider localeServiceProvider = localeProviderAdapter.getLocaleServiceProvider(clazz);
            if (localeServiceProvider == null || !localeServiceProvider.isSupportedLocale(locale)) continue;
            return localeProviderAdapter;
        }
        return null;
    }

    static boolean isSupportedLocale(Locale locale, Type type, Set<String> set) {
        assert (type == Type.JRE || type == Type.CLDR || type == Type.FALLBACK);
        if (Locale.ROOT.equals(locale)) {
            return true;
        }
        if (type == Type.FALLBACK) {
            return false;
        }
        if (set.contains((locale = locale.stripExtensions()).toLanguageTag())) {
            return true;
        }
        if (type == Type.JRE) {
            String string = locale.toString().replace('_', '-');
            return set.contains(string) || "ja-JP-JP".equals(string) || "th-TH-TH".equals(string) || "no-NO-NY".equals(string);
        }
        return false;
    }

    public static Locale[] toLocaleArray(Set<String> set) {
        Locale[] localeArray = new Locale[set.size() + 1];
        int n = 0;
        localeArray[n++] = Locale.ROOT;
        Iterator<String> iterator = set.iterator();
        block8: while (iterator.hasNext()) {
            String string;
            switch (string = iterator.next()) {
                case "ja-JP-JP": {
                    localeArray[n++] = JRELocaleConstants.JA_JP_JP;
                    continue block8;
                }
                case "th-TH-TH": {
                    localeArray[n++] = JRELocaleConstants.TH_TH_TH;
                    continue block8;
                }
            }
            localeArray[n++] = Locale.forLanguageTag(string);
        }
        return localeArray;
    }

    public abstract Type getAdapterType();

    public abstract <P extends LocaleServiceProvider> P getLocaleServiceProvider(Class<P> var1);

    public abstract BreakIteratorProvider getBreakIteratorProvider();

    public abstract CollatorProvider getCollatorProvider();

    public abstract DateFormatProvider getDateFormatProvider();

    public abstract DateFormatSymbolsProvider getDateFormatSymbolsProvider();

    public abstract DecimalFormatSymbolsProvider getDecimalFormatSymbolsProvider();

    public abstract NumberFormatProvider getNumberFormatProvider();

    public abstract CurrencyNameProvider getCurrencyNameProvider();

    public abstract LocaleNameProvider getLocaleNameProvider();

    public abstract TimeZoneNameProvider getTimeZoneNameProvider();

    public abstract CalendarDataProvider getCalendarDataProvider();

    public abstract CalendarNameProvider getCalendarNameProvider();

    public abstract CalendarProvider getCalendarProvider();

    public abstract LocaleResources getLocaleResources(Locale var1);

    public abstract Locale[] getAvailableLocales();

    static {
        jreLocaleProviderAdapter = new JRELocaleProviderAdapter();
        spiLocaleProviderAdapter = new SPILocaleProviderAdapter();
        cldrLocaleProviderAdapter = null;
        hostLocaleProviderAdapter = null;
        fallbackLocaleProviderAdapter = null;
        defaultLocaleProviderAdapter = null;
        adapterCache = new ConcurrentHashMap<Class<? extends LocaleServiceProvider>, ConcurrentMap<Locale, LocaleProviderAdapter>>();
        String string = AccessController.doPrivileged(new GetPropertyAction("java.locale.providers"));
        ArrayList<Type> arrayList = new ArrayList<Type>();
        if (string != null && string.length() != 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                try {
                    Type type = Type.valueOf(string2.trim().toUpperCase(Locale.ROOT));
                    switch (type) {
                        case CLDR: {
                            if (cldrLocaleProviderAdapter != null) break;
                            cldrLocaleProviderAdapter = new CLDRLocaleProviderAdapter();
                            break;
                        }
                        case HOST: {
                            if (hostLocaleProviderAdapter != null) break;
                            hostLocaleProviderAdapter = new HostLocaleProviderAdapter();
                        }
                    }
                    if (arrayList.contains((Object)type)) continue;
                    arrayList.add(type);
                }
                catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                    LocaleServiceProviderPool.config(LocaleProviderAdapter.class, runtimeException.toString());
                }
            }
        }
        if (!arrayList.isEmpty()) {
            if (!arrayList.contains((Object)Type.JRE)) {
                fallbackLocaleProviderAdapter = new FallbackLocaleProviderAdapter();
                arrayList.add(Type.FALLBACK);
                defaultLocaleProviderAdapter = Type.FALLBACK;
            } else {
                defaultLocaleProviderAdapter = Type.JRE;
            }
        } else {
            arrayList.add(Type.JRE);
            arrayList.add(Type.SPI);
            defaultLocaleProviderAdapter = Type.JRE;
        }
        adapterPreference = Collections.unmodifiableList(arrayList);
    }

    public static enum Type {
        JRE("sun.util.resources", "sun.text.resources"),
        CLDR("sun.util.resources.cldr", "sun.text.resources.cldr"),
        SPI,
        HOST,
        FALLBACK("sun.util.resources", "sun.text.resources");

        private final String UTIL_RESOURCES_PACKAGE;
        private final String TEXT_RESOURCES_PACKAGE;

        private Type() {
            this(null, null);
        }

        private Type(String string2, String string3) {
            this.UTIL_RESOURCES_PACKAGE = string2;
            this.TEXT_RESOURCES_PACKAGE = string3;
        }

        public String getUtilResourcesPackage() {
            return this.UTIL_RESOURCES_PACKAGE;
        }

        public String getTextResourcesPackage() {
            return this.TEXT_RESOURCES_PACKAGE;
        }
    }
}

