/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.module;

import com.beust.jcommander.JCommander;
import com.ncloud.api.cli.common.model.CommandEnum;
import com.ncloud.api.cli.common.model.ProfileConfigure;
import com.ncloud.api.cli.common.options.CommandOptions;
import com.ncloud.api.cli.common.options.ConfigureOptions;
import com.ncloud.api.cli.common.options.GlobalOptions;
import com.ncloud.api.cli.common.util.ConfigureUtil;
import com.ncloud.api.cli.common.util.PropertyMessageUtil;
import com.ncloud.api.cli.exception.NcloudCliException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configure {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void execute(JCommander ncloudCommander, CommandEnum.ConfigureCommand configureCommand) throws NcloudCliException, FileNotFoundException {
        this.logger.debug("" + System.getProperty("os.name"));
        this.logger.debug("" + System.getProperty("user.home"));
        this.logger.debug("" + System.getProperty("user.home") + File.separatorChar + ".ncloud" + File.separatorChar + "configure");
        if (configureCommand == null) {
            this.setConfigure(ncloudCommander);
        } else {
            switch (configureCommand) {
                case list: {
                    this.printProfileConfigureList(ncloudCommander, configureCommand);
                    break;
                }
                case clean: {
                    break;
                }
            }
        }
    }

    public void setConfigure(JCommander ncloudCommander) throws NcloudCliException {
        String profile;
        ConfigureOptions configureOptions = (ConfigureOptions)ncloudCommander.getObjects().get(0);
        GlobalOptions globalOptions = configureOptions.getCommandOptions().getGlobalOptions();
        String string = profile = globalOptions.getProfile() == null ? "DEFAULT" : globalOptions.getProfile();
        if (StringUtils.isEmpty(profile)) {
            throw new NcloudCliException("profile cannot be empty.");
        }
        ProfileConfigure profileConfigure = ConfigureUtil.getProfileConfigure(profile);
        if (profileConfigure == null) {
            profileConfigure = new ProfileConfigure(profile);
            ConfigureUtil.addProfileConfigure(profileConfigure);
        }
        String ncloudAccessKeyId = profileConfigure.getAccessKey();
        String ncloudSecretAccessKey = profileConfigure.getSecretKey();
        String ncloudApiUrl = profileConfigure.getApiUrl();
        Scanner scanner = new Scanner(System.in);
        System.out.println(String.format("set [%s]'s configuration.", profile));
        System.out.print("Ncloud Access Key ID [" + ncloudAccessKeyId + "]: ");
        ncloudAccessKeyId = scanner.nextLine();
        System.out.print("Ncloud Secret Access Key [" + ncloudSecretAccessKey + "]: ");
        ncloudSecretAccessKey = scanner.nextLine();
        System.out.print("Ncloud API URL (default:" + PropertyMessageUtil.getMessage("ncloud.api.url") + ") [" + ncloudApiUrl + "]: ");
        ncloudApiUrl = scanner.nextLine();
        if (StringUtils.isEmpty(ncloudApiUrl)) {
            ncloudApiUrl = PropertyMessageUtil.getMessage("ncloud.api.url");
        }
        ConfigureUtil.setConfigures(profileConfigure, ncloudAccessKeyId, ncloudSecretAccessKey, ncloudApiUrl);
    }

    public void printProfileConfigureList(JCommander ncloudCommander, CommandEnum.ConfigureCommand configureCommand) {
        JCommander subCommander = ncloudCommander.getCommands().get(configureCommand.getCode());
        CommandOptions configureOptions = (CommandOptions)subCommander.getObjects().get(0);
        GlobalOptions globalOptions = configureOptions.getGlobalOptions();
        String profile = globalOptions.getProfile();
        List<ProfileConfigure> profileConfigureList = ConfigureUtil.getProfileConfigureList();
        for (ProfileConfigure profileConfigure : profileConfigureList) {
            if (profile != null && !StringUtils.equals(profileConfigure.getProfile(), profile)) continue;
            System.out.println("[" + profileConfigure.getProfile() + "]");
            System.out.println("ncloud_access_key_id = " + profileConfigure.getAccessKey());
            System.out.println("ncloud_secret_access_key = " + profileConfigure.getSecretKey());
            System.out.println("ncloud_api_url = " + profileConfigure.getApiUrl());
            System.out.println();
        }
    }
}

