/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RsaCipherUtil {
    private static Logger logger = LoggerFactory.getLogger(RsaCipherUtil.class);

    public static byte[] encrypt(String openSslPublicKeyString, String encryptPass) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(Base64.decodeBase64(openSslPublicKeyString.getBytes()));
        PublicKey encryptionKey = keyFactory.generatePublic(pubSpec);
        Cipher rsa = Cipher.getInstance("RSA");
        rsa.init(1, encryptionKey);
        return rsa.doFinal(encryptPass.getBytes());
    }

    public static String decrypt(String privateKeyString, byte[] encrypt) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(Base64.decodeBase64(privateKeyString.getBytes()));
        PrivateKey decryptionKey = keyFactory.generatePrivate(privSpec);
        Cipher rsa = Cipher.getInstance("RSA");
        rsa.init(2, decryptionKey);
        byte[] utf8 = rsa.doFinal(encrypt);
        return new String(utf8, "UTF8");
    }

    public static String getEncodePrivateKey(String privateKey) throws IOException {
        ByteArrayInputStream pemStream = new ByteArrayInputStream(privateKey.getBytes());
        String pemData = RsaCipherUtil.readInputStreamToString(pemStream, "UTF-8");
        if (StringUtils.indexOf(pemData, "-----BEGIN RSA PRIVATE KEY-----") < 0 || StringUtils.indexOf(pemData, "-----END RSA PRIVATE KEY-----") < 0) {
            throw new IOException("Check your pem file.");
        }
        String strippedPemData = StringUtils.substringBetween(pemData, "-----BEGIN RSA PRIVATE KEY-----", "-----END RSA PRIVATE KEY-----");
        byte[] derBytes = Base64.decodeBase64(strippedPemData.getBytes("UTF-8"));
        String encodePrivateKey = new String(Base64.encodeBase64(derBytes));
        return encodePrivateKey;
    }

    public static String readInputStreamToString(InputStream is, String encoding) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        br = encoding != null ? new BufferedReader(new InputStreamReader(is, encoding)) : new BufferedReader(new InputStreamReader(is));
        String line = null;
        boolean firstLine = true;
        while ((line = br.readLine()) != null) {
            if (!firstLine) {
                sb.append("\n");
            }
            sb.append(line);
            firstLine = false;
        }
        return sb.toString();
    }

    static {
        try {
            Class<?> bouncyCastleProviderClass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            if (bouncyCastleProviderClass != null) {
                Provider bouncyCastleProvider = (Provider)bouncyCastleProviderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Security.addProvider(bouncyCastleProvider);
            }
        }
        catch (RuntimeException e) {
            logger.error("", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Loaded security provider BouncyCastleProvider");
        }
    }
}

