/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.converter;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import com.ncloud.api.cli.common.util.HttpConnectionUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFileReaderConverter
implements IStringConverter<String> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String convert(String resourcePath) {
        this.logger.debug("resourcePath->" + resourcePath);
        if (StringUtils.isEmpty(resourcePath)) {
            throw new ParameterException("Please check your input value. You have entered a blank string.");
        }
        StringBuffer resourceContent = new StringBuffer();
        if (StringUtils.indexOf(resourcePath, "file://") == 0) {
            resourceContent = this.getFileContent(resourcePath);
        } else if (StringUtils.indexOf(resourcePath, "http://") == 0 || StringUtils.indexOf(resourcePath, "https://") == 0) {
            resourceContent = this.getHttpContent(resourcePath);
        } else {
            resourceContent.append(resourcePath);
        }
        return resourceContent.toString();
    }

    private StringBuffer getHttpContent(String resourcePath) {
        StringBuffer resourceContent = new StringBuffer();
        HttpConnectionUtil httpConnectionUtil = new HttpConnectionUtil();
        try {
            resourceContent.append(httpConnectionUtil.getConnect(resourcePath, "UTF-8"));
        }
        catch (Exception e) {
            this.logger.error("", e);
            throw new ParameterException(e.getMessage());
        }
        return resourceContent;
    }

    private StringBuffer getFileContent(String resourcePath) {
        StringBuffer resourceContent = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(StringUtils.substringAfterLast(resourcePath, "file://")));
            boolean firstLine = true;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!firstLine) {
                    resourceContent.append("\n");
                }
                resourceContent.append(line);
                firstLine = false;
            }
        }
        catch (Exception e) {
            throw new ParameterException(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return resourceContent;
    }
}

